<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::table('attendances', function (Blueprint $table) {
         // Add photo column if not exists
         if (!Schema::hasColumn('attendances', 'photo')) {
            $table->string('photo')->nullable()->after('attachment');
         }
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::table('attendances', function (Blueprint $table) {
         if (Schema::hasColumn('attendances', 'photo')) {
            $table->dropColumn('photo');
         }
      });
   }
};
